/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.impl.Utils;
import com.floragunn.searchguard.user.UserInformation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class AuditMessage {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String FORMAT_VERSION = "audit_format_version";
    public static final String CATEGORY = "audit_category";
    public static final String REQUEST_EFFECTIVE_USER = "audit_request_effective_user";
    public static final String REQUEST_EFFECTIVE_USER_AUTH_DOMAIN = "audit_request_effective_user_auth_domain";
    public static final String REQUEST_INITIATING_USER = "audit_request_initiating_user";
    public static final String REQUEST_INITIATING_USER_AUTH_DOMAIN = "audit_request_initiating_user_auth_domain";
    public static final String UTC_TIMESTAMP = "@timestamp";
    public static final String CLUSTER_NAME = "audit_cluster_name";
    public static final String NODE_ID = "audit_node_id";
    public static final String NODE_HOST_ADDRESS = "audit_node_host_address";
    public static final String NODE_HOST_NAME = "audit_node_host_name";
    public static final String NODE_NAME = "audit_node_name";
    public static final String ORIGIN = "audit_request_origin";
    public static final String REMOTE_ADDRESS = "audit_request_remote_address";
    public static final String REST_REQUEST_PATH = "audit_rest_request_path";
    public static final String REST_REQUEST_PARAMS = "audit_rest_request_params";
    public static final String REST_REQUEST_HEADERS = "audit_rest_request_headers";
    public static final String TRANSPORT_REQUEST_TYPE = "audit_transport_request_type";
    public static final String TRANSPORT_ACTION = "audit_transport_action";
    public static final String TRANSPORT_REQUEST_HEADERS = "audit_transport_headers";
    public static final String ID = "audit_trace_doc_id";
    public static final String INDICES = "audit_trace_indices";
    public static final String SHARD_ID = "audit_trace_shard_id";
    public static final String RESOLVED_INDICES = "audit_trace_resolved_indices";
    public static final String EXCEPTION = "audit_request_exception_stacktrace";
    public static final String IS_ADMIN_DN = "audit_request_effective_user_is_admin";
    public static final String PRIVILEGE = "audit_request_privilege";
    public static final String TASK_ID = "audit_trace_task_id";
    public static final String TASK_PARENT_ID = "audit_trace_task_parent_id";
    public static final String REQUEST_BODY = "audit_request_body";
    public static final String COMPLIANCE_DIFF_IS_NOOP = "audit_compliance_diff_is_noop";
    public static final String COMPLIANCE_DIFF_CONTENT = "audit_compliance_diff_content";
    public static final String COMPLIANCE_FILE_INFOS = "audit_compliance_file_infos";
    public static final String REQUEST_LAYER = "audit_request_layer";
    public static final String COMPLIANCE_OPERATION = "audit_compliance_operation";
    public static final String COMPLIANCE_DOC_VERSION = "audit_compliance_doc_version";
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private final Map<String, Object> auditInfo = new HashMap<String, Object>(50);
    private final Category msgCategory;

    public AuditMessage(Category msgCategory, ClusterState clusterState, AuditLog.Origin origin, AuditLog.Origin layer) {
        this.msgCategory = Objects.requireNonNull(msgCategory);
        String currentTime = this.currentTime();
        this.auditInfo.put(FORMAT_VERSION, 4);
        this.auditInfo.put(CATEGORY, (Object)Objects.requireNonNull(msgCategory));
        this.auditInfo.put(UTC_TIMESTAMP, currentTime);
        ClusterState localClusterState = clusterState;
        if (localClusterState != null) {
            DiscoveryNode localNode = localClusterState.nodes().getLocalNode();
            this.auditInfo.put(CLUSTER_NAME, clusterState.getClusterName().value());
            this.auditInfo.put(NODE_HOST_ADDRESS, localNode.getHostAddress());
            this.auditInfo.put(NODE_ID, localNode.getId());
            this.auditInfo.put(NODE_HOST_NAME, localNode.getHostName());
            this.auditInfo.put(NODE_NAME, localNode.getName());
        }
        if (origin != null) {
            this.auditInfo.put(ORIGIN, origin);
        }
        if (layer != null) {
            this.auditInfo.put(REQUEST_LAYER, layer);
        }
    }

    public void addRemoteAddress(TransportAddress remoteAddress) {
        if (remoteAddress != null && remoteAddress.getAddress() != null) {
            this.auditInfo.put(REMOTE_ADDRESS, remoteAddress.getAddress());
        }
    }

    public void addRemoteAddress(String remoteAddress) {
        this.auditInfo.put(REMOTE_ADDRESS, remoteAddress);
    }

    public void addIsAdminDn(boolean isAdminDn) {
        this.auditInfo.put(IS_ADMIN_DN, isAdminDn);
    }

    public void addException(Throwable t) {
        if (t != null) {
            this.auditInfo.put(EXCEPTION, ExceptionsHelper.stackTrace((Throwable)t));
        }
    }

    public void addPrivilege(String priv) {
        if (priv != null) {
            this.auditInfo.put(PRIVILEGE, priv);
        }
    }

    public void addInitiatingUser(String user) {
        if (user != null) {
            this.auditInfo.put(REQUEST_INITIATING_USER, user);
        }
    }

    public void addInitiatingUser(UserInformation user) {
        if (user != null && user.getName() != null) {
            this.auditInfo.put(REQUEST_INITIATING_USER, user.getName());
        }
        if (user != null && user.getAuthDomain() != null) {
            this.auditInfo.put(REQUEST_INITIATING_USER_AUTH_DOMAIN, user.getAuthDomain());
        }
    }

    public void addEffectiveUser(String user) {
        if (user != null) {
            this.auditInfo.put(REQUEST_EFFECTIVE_USER, user);
        }
    }

    public void addEffectiveUser(UserInformation user) {
        if (user != null && user.getName() != null) {
            this.auditInfo.put(REQUEST_EFFECTIVE_USER, user.getName());
        }
        if (user != null && user.getAuthDomain() != null) {
            this.auditInfo.put(REQUEST_EFFECTIVE_USER_AUTH_DOMAIN, user.getAuthDomain());
        }
    }

    public void addPath(String path) {
        if (path != null) {
            this.auditInfo.put(REST_REQUEST_PATH, path);
        }
    }

    public void addComplianceWriteDiffSource(String diff) {
        if (diff != null && !diff.isEmpty()) {
            this.auditInfo.put(COMPLIANCE_DIFF_CONTENT, diff);
            this.auditInfo.put(COMPLIANCE_DIFF_IS_NOOP, false);
        } else if (diff != null && diff.isEmpty()) {
            this.auditInfo.put(COMPLIANCE_DIFF_IS_NOOP, true);
        }
    }

    public void addTupleToRequestBody(Tuple<XContentType, BytesReference> xContentTuple) {
        if (xContentTuple != null) {
            try {
                this.auditInfo.put(REQUEST_BODY, XContentHelper.convertToJson((BytesReference)((BytesReference)xContentTuple.v2()), (boolean)false, (XContentType)((XContentType)xContentTuple.v1())));
            }
            catch (Exception e) {
                this.auditInfo.put(REQUEST_BODY, "ERROR: Unable to convert to json because of " + e);
            }
        }
    }

    public void addMapToRequestBody(Map<String, Object> map) {
        if (map != null) {
            this.auditInfo.put(REQUEST_BODY, Utils.convertStructuredMapToJson(map));
        }
    }

    public void addUnescapedJsonToRequestBody(String source) {
        if (source != null) {
            this.auditInfo.put(REQUEST_BODY, source);
        }
    }

    public void addRequestType(String requestType) {
        if (requestType != null) {
            this.auditInfo.put(TRANSPORT_REQUEST_TYPE, requestType);
        }
    }

    public void addAction(String action) {
        if (action != null) {
            this.auditInfo.put(TRANSPORT_ACTION, action);
        }
    }

    public void addId(String id) {
        if (id != null) {
            this.auditInfo.put(ID, id);
        }
    }

    public void addFileInfos(Map<String, Path> paths) {
        if (paths != null && !paths.isEmpty()) {
            ArrayList infos = new ArrayList();
            for (Map.Entry<String, Path> path : paths.entrySet()) {
                try {
                    if (!Files.isReadable(path.getValue())) continue;
                    String chcksm = DigestUtils.sha256Hex((byte[])Files.readAllBytes(path.getValue()));
                    FileTime lm = Files.getLastModifiedTime(path.getValue(), LinkOption.NOFOLLOW_LINKS);
                    HashMap<String, String> innerInfos = new HashMap<String, String>();
                    innerInfos.put("sha256", chcksm);
                    innerInfos.put("last_modified", this.formatTime(lm.toMillis()));
                    innerInfos.put("key", path.getKey());
                    innerInfos.put("path", path.getValue().toAbsolutePath().toString());
                    infos.add(innerInfos);
                }
                catch (Throwable throwable) {}
            }
            this.auditInfo.put(COMPLIANCE_FILE_INFOS, infos);
        }
    }

    public void addIndices(String[] indices) {
        if (indices != null && indices.length > 0) {
            this.auditInfo.put(INDICES, indices);
        }
    }

    public void addResolvedIndices(String[] resolvedIndices) {
        if (resolvedIndices != null && resolvedIndices.length > 0) {
            this.auditInfo.put(RESOLVED_INDICES, resolvedIndices);
        }
    }

    public void addTaskId(long id) {
        this.auditInfo.put(TASK_ID, this.auditInfo.get(NODE_ID) + ":" + id);
    }

    public void addShardId(ShardId id) {
        if (id != null) {
            this.auditInfo.put(SHARD_ID, id.getId());
        }
    }

    public void addTaskParentId(String id) {
        if (id != null) {
            this.auditInfo.put(TASK_PARENT_ID, id);
        }
    }

    public void addRestParams(Map<String, String> params) {
        if (params != null && !params.isEmpty()) {
            this.auditInfo.put(REST_REQUEST_PARAMS, new HashMap<String, String>(params));
        }
    }

    public void addRestHeaders(Map<String, List<String>> headers, boolean excludeSensitiveHeaders) {
        if (headers != null && !headers.isEmpty()) {
            if (excludeSensitiveHeaders) {
                Map<String, List> headersClone = new HashMap<String, List<String>>(headers).entrySet().stream().filter(map -> !((String)map.getKey()).equalsIgnoreCase(AUTHORIZATION_HEADER)).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (List)p.getValue()));
                this.auditInfo.put(REST_REQUEST_HEADERS, headersClone);
            } else {
                this.auditInfo.put(REST_REQUEST_HEADERS, new HashMap<String, List<String>>(headers));
            }
        }
    }

    public void addTransportHeaders(Map<String, String> headers, boolean excludeSensitiveHeaders) {
        if (headers != null && !headers.isEmpty()) {
            if (excludeSensitiveHeaders) {
                Map<String, String> headersClone = new HashMap<String, String>(headers).entrySet().stream().filter(map -> !((String)map.getKey()).equalsIgnoreCase(AUTHORIZATION_HEADER)).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue()));
                this.auditInfo.put(TRANSPORT_REQUEST_HEADERS, headersClone);
            } else {
                this.auditInfo.put(TRANSPORT_REQUEST_HEADERS, new HashMap<String, String>(headers));
            }
        }
    }

    public void addComplianceOperation(AuditLog.Operation op) {
        if (op != null) {
            this.auditInfo.put(COMPLIANCE_OPERATION, op);
        }
    }

    public void addComplianceDocVersion(long version) {
        this.auditInfo.put(COMPLIANCE_DOC_VERSION, version);
    }

    public Map<String, Object> getAsMap() {
        return new HashMap<String, Object>(this.auditInfo);
    }

    public String getInitiatingUser() {
        return (String)this.auditInfo.get(REQUEST_INITIATING_USER);
    }

    public String getEffectiveUser() {
        return (String)this.auditInfo.get(REQUEST_EFFECTIVE_USER);
    }

    public String getRequestType() {
        return (String)this.auditInfo.get(TRANSPORT_REQUEST_TYPE);
    }

    public Category getCategory() {
        return this.msgCategory;
    }

    public String toString() {
        try {
            return Strings.toString((XContentBuilder)JsonXContent.contentBuilder().map(this.getAsMap()));
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    public String toPrettyString() {
        try {
            return Strings.toString((XContentBuilder)JsonXContent.contentBuilder().prettyPrint().map(this.getAsMap()));
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    public String toText() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.getAsMap().entrySet()) {
            AuditMessage.addIfNonEmpty(builder, entry.getKey(), this.stringOrNull(entry.getValue()));
        }
        return builder.toString();
    }

    public String toJson() {
        return this.toString();
    }

    public String toUrlParameters() {
        URIBuilder builder = new URIBuilder();
        for (Map.Entry<String, Object> entry : this.getAsMap().entrySet()) {
            builder.addParameter(entry.getKey(), this.stringOrNull(entry.getValue()));
        }
        return builder.toString();
    }

    private static void addIfNonEmpty(StringBuilder builder, String key, String value) {
        if (!Strings.isEmpty((CharSequence)value)) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(key).append(": ").append(value);
        }
    }

    private String currentTime() {
        DateTime dt = new DateTime(DateTimeZone.UTC);
        return DEFAULT_FORMAT.print((ReadableInstant)dt);
    }

    private String formatTime(long epoch) {
        DateTime dt = new DateTime(epoch, DateTimeZone.UTC);
        return DEFAULT_FORMAT.print((ReadableInstant)dt);
    }

    private String stringOrNull(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static enum Category {
        BAD_HEADERS,
        FAILED_LOGIN,
        BLOCKED_IP,
        BLOCKED_USER,
        MISSING_PRIVILEGES,
        SG_INDEX_ATTEMPT,
        SSL_EXCEPTION,
        AUTHENTICATED,
        GRANTED_PRIVILEGES,
        COMPLIANCE_DOC_READ,
        COMPLIANCE_DOC_WRITE,
        COMPLIANCE_EXTERNAL_CONFIG,
        COMPLIANCE_INTERNAL_CONFIG_READ,
        COMPLIANCE_INTERNAL_CONFIG_WRITE,
        COMPLIANCE_IMMUTABLE_INDEX_ATTEMPT;

    }
}

